﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ProjetDotNet.COR;
using ProjetDotNet.metier;

namespace ProjetDotNet.fenetre
{
    public partial class ChargerFenêtre : Form
    {
        ListeForme tousLesFormes;

        private CORChargerTriangle maillonTriangle;
        private CORChargerSegment maillonSegment;
        private CORChargerRectangle maillonRect;
        private CORChargerPolygone maillonPolygone;
        private CORChargerGroupe maillonGroupe;

        private Forme FormeCharger;

        public ChargerFenêtre(ListeForme tousLesFormes)
        {
            this.tousLesFormes = tousLesFormes;

            maillonTriangle = new CORChargerTriangle();
            maillonSegment = new CORChargerSegment();
            maillonRect = new CORChargerRectangle();
            maillonPolygone = new CORChargerPolygone();
            maillonGroupe = new CORChargerGroupe();

            maillonTriangle.SetSuccessor(maillonSegment);
            maillonSegment.SetSuccessor(maillonRect);
            maillonRect.SetSuccessor(maillonPolygone);
            maillonPolygone.SetSuccessor(maillonGroupe);

            InitializeComponent();
        }

        private void LoadForme(object sender, EventArgs e)
        {
            if (this.textBox_id.Text != "" && this.textBox_nom.Text != "")
            {
                int id = int.Parse(this.textBox_id.Text);
                string nom = this.textBox_nom.Text;

                // MessageBox.Show("Veuillez saisir l'id et le nom", "Attention", MessageBoxButtons.OK, MessageBoxIcon.Information);
                FormeCharger = maillonTriangle.charge(id, nom);

                this.DialogResult = DialogResult.OK;

                this.Close();
            }

        }

        public Forme getForme()
        {
            return this.FormeCharger;
        }
    }
}
