﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using ProjetDotNet.fenetre;
using ProjetDotNet.metier;
using ProjetDotNet.mouseEvent;

namespace ProjetDotNet
{

    delegate void DeleguerForme(int x, int y);


    public partial class FenetreDessin : Form
    {

        // private Groupe listeForme;
        private FormeSimple FormeCourante;
        private Transformation.Transformation FormeATransformer;

        private MouseClickManager mouseManager;
        //private Groupe groupes;
        private ListeForme tousLesFormes;
        private int nbPointAPlacer;
        private int nbPointPlace;
        private ToolStripButton ObjectClicked;

        private PointForme CentreTransformation;


        public FenetreDessin()
        {
            InitializeComponent();
            
            mouseManager = new MouseClickManager(this.zoneDessin);

            //groupes = new Groupe("Tous les formes");
            tousLesFormes = new ListeForme();
 
            FormeCourante = null;
            ObjectClicked = null;

            CentreTransformation = null;
            FormeATransformer = null;

            nbPointAPlacer = 0;
            nbPointPlace = 0;

        }

        double Distance(int x1, int y1, int x2, int y2)
        {
            return Math.Sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        }
        /* pour les delegués */

        void PlacerPoint(object sender, EventArgs e)
        {
            MouseEventArgs e1 = (MouseEventArgs)e;
            int x = e1.X, y = e1.Y;
            FormeCourante.ListePoint.Add(new PointForme(x, y));
            System.Console.WriteLine("PlacerPoint");

            nbPointPlace += 1;
            if (nbPointAPlacer == nbPointPlace || (Distance(x, y, (int)FormeCourante.ListePoint[0].X, (int)FormeCourante.ListePoint[0].Y) < 20 && nbPointPlace > 3))
            {
                if (nbPointAPlacer == -1 && Distance(x, y, (int)FormeCourante.ListePoint[0].X, (int)FormeCourante.ListePoint[0].Y) == 0)
                    FormeCourante.ListePoint.RemoveAt(FormeCourante.ListePoint.Count - 1);
                int nbFormeSuiv = tousLesFormes.NombreForme() + 1;
                DialogueForme dialogue = new DialogueForme(FormeCourante.Nom + "_" + nbFormeSuiv);
                if (dialogue.ShowDialog(this) == DialogResult.OK)
                {
                    if (dialogue.getName() == "")
                        FormeCourante.Nom = FormeCourante.Nom + "_" + nbFormeSuiv;
                    else
                        FormeCourante.Nom = dialogue.getName();
                }
                tousLesFormes.Add(FormeCourante);
                FormeCourante = null;
                nbPointPlace = 0;
                ObjectClicked.Checked = false;
                mouseManager.deleteAllEvent();
                this.StatusBar.Text = "";

            }
            else
                this.StatusBar.Text = "Veuillez placer le point suivant";
        }

        void PlacerPointTransformation(object sender, EventArgs e)
        {
            MouseEventArgs e1 = (MouseEventArgs)e;
            int x = e1.X, y = e1.Y;

            if (CentreTransformation == null)
            {
                CentreTransformation = new PointForme(x, y);
                this.StatusBar.Text = "Vous pouvez maintenant transformer l'objet";
                statusStrip.Refresh();
            }
            else
            {
                Forme f = FormeATransformer.AppliquerTransforation(CentreTransformation, new PointForme(x, y));
                tousLesFormes.Add(f);
                FormeATransformer = null;
                mouseManager.deleteAllEvent();
                CentreTransformation = null;
                this.StatusBar.Text = "";

            }
        }
        /* fin */


        /*Créer une boite de dialogue afin de connaitre le nom et la couleur du segment A CHANGER*/
        private void segmentDialog(object sender, EventArgs e)
        {
            DialogueForme dialogue = new DialogueForme("Segment");

            if(dialogue.ShowDialog(this) == DialogResult.OK)
            {
               /* this.listeForme.Add(new Segment());
                int tailleListe = listeForme.Count;
                listeForme[tailleListe - 1].Nom = dialogue.Nom;
                ((Segment)listeForme[tailleListe - 1]).Couleur = dialogue.Couleur;
                valider = true;
                point1 = true;*/

            }
        }


    

        private void FenetreDessin_Load(object sender, EventArgs e)
        {

        }

        private void CreerForme(FormeSimple f, int nbPointAPlacer, string nom, ToolStripButton button)
        {
            if ((FormeATransformer == null && CentreTransformation == null))
            {
                mouseManager.deleteAllEvent();
                mouseManager.addEvent(PlacerPoint);
                
                this.FormeCourante = f;
                this.nbPointAPlacer = nbPointAPlacer;
                this.nbPointPlace = 0;
                FormeCourante.Nom = nom;
                FormeCourante.Couleur = buttonColor.BackColor;

                if (ObjectClicked != null)
                    ObjectClicked.Checked = false;

                this.StatusBar.Text = "Veuillez placer le premier point";

                button.Checked = true;
                ObjectClicked = button;
            }
        }

        private void TSB_Segment_Click(object sender, EventArgs e)
        {
            CreerForme(new Segment(), 2, "segment", ButtonSegment);
        }

        private void TSB_Rectangle_Click(object sender, EventArgs e)
        {
            CreerForme(new Rect(), 2, "rectangle", ButtonRectangle);
        }

        private void TSB_Triangle_Click(object sender, EventArgs e)
        {
            CreerForme(new Triangle(), 3, "triangle", ButtonTriangle);
        }

        private void TSB_Elipse_Click(object sender, EventArgs e)
        {
            CreerForme(new Ellipse(), 2, "ellipse", ButtonEllipse);
        }

        private void TSB_Polygone_Click(object sender, EventArgs e)
        {

            CreerForme(new Polygone(), -1, "polygone", ButtonPolygone);
        }

        private void zoneDessin_Click(object sender, EventArgs e)
        {
            MouseEventArgs e1 = (MouseEventArgs)e;
            //if (DeleguerCourant != null)
            //{
                //PlacerPoint(e1.X, e1.Y);
            //}
        }

        private void toolStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }

        private void statusStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }

        private void buttonColor_Clicked(object sender, EventArgs e)
        {
            ColorDialog MyDialog = new ColorDialog();
            // Keeps the user from selecting a custom color.
            MyDialog.AllowFullOpen = false;
            // Allows the user to get help. (The default is false.)
            MyDialog.ShowHelp = true;
            // Sets the initial color select to the current text color.
            MyDialog.Color = buttonColor.BackColor;

            // Update the text box color if the user clicks OK 
            if (MyDialog.ShowDialog() == DialogResult.OK)
            {
                buttonColor.BackColor = MyDialog.Color;
                if (FormeCourante != null)
                    FormeCourante.Couleur = buttonColor.BackColor;
            }
        }

        private void menuStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }

        private void display_currentForm(object sender, MouseEventArgs e)
        {
            if (!(FormeATransformer != null && CentreTransformation == null) )
                using (Graphics g = zoneDessin.CreateGraphics())
                {
                    this.Refresh();
                    tousLesFormes.Draw(g);

                    if (FormeCourante != null && FormeCourante.ListePoint.Count > 0)
                    {
                        FormeCourante.ListePoint.Add(new PointForme(e.X, e.Y));
                    
                        FormeCourante.Draw(g);
                    
                        FormeCourante.ListePoint.RemoveAt(FormeCourante.ListePoint.Count - 1);
                    }
                    if (FormeATransformer != null)
                    {
                        if (CentreTransformation != null)
                        {
                            FormeATransformer.AppliquerTransforation(CentreTransformation, new PointForme(e.X, e.Y)).Draw(g);
                        }
                    }
                }

        }

        private void TSB_Grouper_Click(object sender, EventArgs e)
        {
            GroupeFenetre fenetreGroupe = new GroupeFenetre(this.tousLesFormes);

            if (fenetreGroupe.ShowDialog() == DialogResult.OK)
            {
                this.tousLesFormes = new ListeForme(fenetreGroupe.getFormes().TousLesFormes);
            }
        }

        private void ChoixFormeTranslation(Transformation.Transformation t, FenetreChoixFormTransformation fenetreForme)
        {
            string name = fenetreForme.getName();

            mouseManager.deleteAllEvent();
            mouseManager.addEvent(PlacerPointTransformation);

            Forme f = tousLesFormes.GetFormeByName(name);
            this.FormeATransformer = t;
            tousLesFormes.Remove(f);

            if (ObjectClicked != null)
                ObjectClicked.Checked = false;
            System.Console.WriteLine("Forme créér");
            this.StatusBar.Text = "Placer le centre de transformation";
            statusStrip.Refresh();
        }

        private void TSB_Homothetie(object sender, EventArgs e)
        {
            FenetreChoixFormTransformation fenetreForme = new FenetreChoixFormTransformation(this.tousLesFormes);

            if (fenetreForme.ShowDialog() == DialogResult.OK)
            {
                string name = fenetreForme.getName();
                ChoixFormeTranslation(new Transformation.Homothetie(tousLesFormes.GetFormeByName(name)), fenetreForme);
            }
        }

        private void TSB_Translation(object sender, EventArgs e)
        {
            FenetreChoixFormTransformation fenetreForme = new FenetreChoixFormTransformation(this.tousLesFormes);

            if (fenetreForme.ShowDialog() == DialogResult.OK)
            {
                string name = fenetreForme.getName();
                ChoixFormeTranslation(new Transformation.Translation(tousLesFormes.GetFormeByName(name)), fenetreForme);
            }
        }


        private void chrargerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ChargerFenêtre fenetre = new ChargerFenêtre(this.tousLesFormes);

            if (fenetre.ShowDialog() == DialogResult.OK)
            {
                if (fenetre.getForme() != null)
                    this.tousLesFormes.Add(fenetre.getForme());

            }
        }

        private void sauvegarderToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SauvegardeFenêtre fenêtre = new SauvegardeFenêtre(this.tousLesFormes);

            if (fenêtre.ShowDialog() == DialogResult.OK)
            {

            }
        }

        private void ResizeCanvas(object sender, EventArgs e)
        {
            //this.zoneDessin.
        }

        private void nouveauToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mouseManager = new MouseClickManager(this.zoneDessin);

            //groupes = new Groupe("Tous les formes");
            tousLesFormes = new ListeForme();

            FormeCourante = null;
            ObjectClicked = null;

            CentreTransformation = null;
            FormeATransformer = null;

            nbPointAPlacer = 0;
            nbPointPlace = 0;
        }


    }
}
