﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ProjetDotNet.fenetre
{
    public partial class GroupeFenetre : Form
    {
        private metier.ListeForme tousLesFormes;
        private bool isClicked;

        public metier.ListeForme getFormes() {
            return tousLesFormes;
        }

        public GroupeFenetre(metier.ListeForme tousLesFormes)
        {
            this.tousLesFormes = new metier.ListeForme(tousLesFormes.TousLesFormes); 
            InitializeComponent();
            this.tousLesFormes.GenerateTreeView(this.TousLesGroupes);
            isClicked = false;
        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void ElementSelectionne(object sender, TreeViewEventArgs e)
        {
            if (isClicked)
            {
                if (e.Node.ForeColor == Color.Black)
                {
                    string nom = e.Node.Text;
                    this.AGrouper.Nodes.Add(nom);
                    this.AGrouper.Nodes[this.AGrouper.Nodes.Count - 1].NodeFont = e.Node.NodeFont;
                    this.AGrouper.Nodes[this.AGrouper.Nodes.Count - 1].Tag = e.Node.Tag;
                    System.Console.WriteLine(nom);
                    e.Node.ForeColor = Color.Gray;
                }
            }
            else { 
                this.TousLesGroupes.SelectedNode = null; 
            }
            isClicked = true;
        }

        private void GrouperFormeSelectionne(object sender, EventArgs e)
        {
            if (textBoxNom.Text.Trim() != "")
            {
                metier.Groupe nouvelleGroupe = new metier.Groupe(textBoxNom.Text);
                foreach (TreeNode t in this.AGrouper.Nodes)
                {
                    metier.Forme f = (metier.Forme) t.Tag;
                    nouvelleGroupe.Add(f);
                    tousLesFormes.Remove(f);
                }
                this.tousLesFormes.Add(nouvelleGroupe);
                this.AGrouper.Nodes.Clear();

                this.TousLesGroupes.Nodes.Clear();
                this.tousLesFormes.GenerateTreeView(this.TousLesGroupes);
            }
            else
            {
                MessageBox.Show("Veuillez saisir un nom", "Attention", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }


        }

        private void SupprimerElement(object sender, TreeViewEventArgs e)
        {
            //string nom = e.Node.Text;
           // e.Node.Remove();
            /*foreach (TreeNode t in this.AGrouper.Nodes)
                if (t.Text == nom)
                    t.Remove();*/
          
        }

        private void button3_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void Ungroup(object sender, EventArgs e)
        {
            foreach (TreeNode t in this.AGrouper.Nodes)
            {
                if (t.NodeFont != null)
                {
                    metier.Groupe f = (metier.Groupe)tousLesFormes.GetFormeByName(t.Text);
                    tousLesFormes.Add(f.ListeForme);
                    this.tousLesFormes.Remove(f);
                }
            }
            

            this.AGrouper.Nodes.Clear();
            this.TousLesGroupes.Nodes.Clear();
            this.tousLesFormes.GenerateTreeView(this.TousLesGroupes);
        }

        private void SupprimerFormes(object sender, EventArgs e)
        {
            foreach (TreeNode t in this.AGrouper.Nodes)
            {
                metier.Forme f = (metier.Forme) t.Tag;
                this.tousLesFormes.Remove(f);
            }


            this.AGrouper.Nodes.Clear();
            this.TousLesGroupes.Nodes.Clear();
            this.tousLesFormes.GenerateTreeView(this.TousLesGroupes);
        }
    }
}
