﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ProjetDotNet.fenetre
{
    public partial class SauvegardeFenêtre : Form
    {
        private metier.ListeForme tousLesFormes;
        private bool isClicked;

        public metier.ListeForme getFormes() {
            return tousLesFormes;
        }

        public SauvegardeFenêtre(metier.ListeForme tousLesFormes)
        {
            this.tousLesFormes = new metier.ListeForme(tousLesFormes.TousLesFormes); 
            InitializeComponent();
            this.tousLesFormes.GenerateTreeView(this.TreeViewTousFormes);
            isClicked = false;
        }

        private void label2_Click(object sender, EventArgs e)
        {

        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void ElementSelectionne(object sender, TreeViewEventArgs e)
        {
            if (isClicked)
            {
                if (e.Node.ForeColor == Color.Black)
                {
                    string nom = e.Node.Text;
                    this.TreeViewASauvegarder.Nodes.Add(nom);
                    this.TreeViewASauvegarder.Nodes[this.TreeViewASauvegarder.Nodes.Count - 1].NodeFont = e.Node.NodeFont;
                    this.TreeViewASauvegarder.Nodes[this.TreeViewASauvegarder.Nodes.Count - 1].Tag = e.Node.Tag;
                    System.Console.WriteLine(nom);
                    e.Node.ForeColor = Color.Gray;
                }
            }
            else
            {
                this.TreeViewTousFormes.SelectedNode = null;
            }
            isClicked = true;
        }

        private void SauvegarderFormes(object sender, EventArgs e)
        {
            foreach (TreeNode t in this.TreeViewASauvegarder.Nodes)
            {
                metier.Forme f = (metier.Forme)t.Tag;
                f.save();
            }
        }
    }
}
