﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using ProjetDotNet.web;

namespace ProjetDotNet.metier
{
    /*
     * Représente une ellipse 
     */
    public class Ellipse : FormeSimple
    {
        public Ellipse():base()
        {

        }

        public Ellipse(String nom, Color couleur):base(nom, couleur)
        {
        }

        public override Forme Translation(PointForme p1, PointForme p2)
        {
            Ellipse e = new Ellipse(this.Nom, this.Couleur);
            e = (Ellipse) this.TranslationPoint(e, p1, p2);
            return e;
        }

        public override Forme Rotation(PointForme centre, double angle)
        {
            Ellipse e = new Ellipse(this.Nom, this.Couleur);
            e = (Ellipse) this.RotationPoint(e, centre, angle);
            return e;
        }

        public override Forme Homothetie(PointForme p, double zoom)
        {
            Ellipse e = new Ellipse(this.Nom, this.Couleur);
            e = (Ellipse)this.HomothetiePoint(e, p, zoom);
            return e;
        }




        public override void Draw(Graphics g)
        {
            Pen p = new Pen(this.Couleur, 2);
            double x = this.ListePoint[0].X;
            double y = this.ListePoint[0].Y;
            double h = this.ListePoint[1].Y - this.ListePoint[0].Y;
            double w = this.ListePoint[1].X - this.ListePoint[0].X;
            g.DrawEllipse(p, (int)x, (int)y, (int)w, (int)h);
        }

        public override void save()
        {
            SingletonConnexion connexion = null;
            connexion = SingletonConnexion.getInstance();
            //connexion.DAO_ELIPSE.save(this);
        }
    }
}
