﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace ProjetDotNet.metier
{
    /*
     * Représente une forme 2D
     */
    public abstract class Forme
    {
        private String _nom;

        public String Nom
        {
            get
            {
                return _nom;
            }
            set
            {
                _nom = value;
            }
        }

        public Forme()
        {
            _nom = "vide";
        }

        public Forme(Forme f)
        {
            _nom = "vide";
        }

        public Forme(String nom)
        {
            _nom = nom;
        }

        public override String ToString()
        {
            return "\nnom =" + _nom;
        }

        /* Translation, rotation, homothétie */

        public abstract Forme Translation(PointForme p1, PointForme p2);

        public abstract Forme Rotation(PointForme centre, double angle);

        public abstract Forme Homothetie(PointForme p, double zoom);

        /* sauvegarde et chargement dans une BDD */

        public abstract void save();

        //public abstract void load(int clef);

        public abstract void Draw(Graphics g);

        public abstract int NombreForme();


        public abstract bool IsPresent(string name);
        public abstract bool IsGroup();

        public abstract Forme GetFormeByName(string nom);
       
    }
}
