﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace ProjetDotNet.metier
{   /*
     * représente une forme simple c'est a dire une forme unique tel qu'un segment, un triangle...etc
     */
    public abstract class FormeSimple : Forme
    {
        private Color _couleur;
        private List<PointForme> _listePoint; //Chaque forme simple possède au moins 1 point

        public FormeSimple():base()
        {
            _couleur = Color.White;
            _listePoint = new List<PointForme>();
        }

        public FormeSimple(String nom, Color couleur): base(nom)
        {
            _couleur = couleur;
            _listePoint = new List<PointForme>();
        }

        public FormeSimple(String nom, Color couleur,List<PointForme> liste):base(nom)
        {
            _couleur = couleur;
            _listePoint = new List<PointForme>(liste);
        }

        public Color Couleur
        {
            get
            {
                return _couleur;
            }
            set
            {
                _couleur = value;
            }
        }

        public List<PointForme> ListePoint
        {
            get
            {
                return _listePoint;
            }
            set
            {
                _listePoint = value;
            }
        }

        

        public override String ToString()
        {
            return base.ToString() + " couleur = " + _couleur;
        }

        protected FormeSimple TranslationPoint(FormeSimple f, PointForme p1, PointForme p2)
        {
            foreach (PointForme point in _listePoint)
            {
                f.ListePoint.Add(point.translation(p1, p2));
            }
            return f;
        }

        protected FormeSimple HomothetiePoint(FormeSimple f, PointForme p, double zoom)
        {
            foreach (PointForme point in _listePoint)
            {
                f.ListePoint.Add(point.homothetie(p, zoom));
            }
            return f;
        }
        protected FormeSimple RotationPoint(FormeSimple f, PointForme centre, double angle)
        {
            foreach (PointForme point in _listePoint)
            {
                f.ListePoint.Add(point.rotation(centre, angle));
            }
            return f;
        }

        public override bool IsPresent(string name)
        {
            return (name == this.Nom);
        }

        public override bool IsGroup()
        {
            return false;
        }

        public override Forme GetFormeByName(string nom)
        {
            if (this.Nom == nom)
                return this;
            else
                return null;
        }

        public override int NombreForme()
        {
            return 1;
        }

    }
}
