﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using ProjetDotNet.web;

namespace ProjetDotNet.metier
{
    /*
     * Représente un groupe de forme, elle peut etre composé d'un groupe
     */
    public class Groupe:Forme
    {
        private List<Forme> _listeForme; //Référence des formes ? comme ça si changement d'une figure alors changement dans le groupe aussi

        public List<Forme> ListeForme
        {
            get
            {
                return _listeForme;
            }
            set
            {
                _listeForme = value;
            }
        }

        public Groupe(String nom):base(nom)
        {
            _listeForme = new List<Forme>();
        }

        public Groupe(Groupe g)
            : base(g.Nom)
        {
            _listeForme = new List<Forme>();
            foreach (Forme s in g.ListeForme)
            {
                _listeForme.Add(s);
            }
        }

        public Groupe(string nomGroupe, List<Forme> listeForme)
        {
            this.Nom = nomGroupe;
            this.ListeForme = listeForme;
        }

        public void Add(Forme forme)
        {
            _listeForme.Add(forme);
        }

        public bool Remove(Forme forme)
        {
            return _listeForme.Remove(forme);
        }

        public Forme Find(Forme forme)
        {
            return _listeForme.Find(f => f == forme);
        }

        public override Forme GetFormeByName(string nom)
        {
            if (this.Nom == nom)
                return this;
            else
            {
                foreach (Forme s in _listeForme)
                {
                    Forme temp = s.GetFormeByName(nom);
                    if (temp != null)
                        return temp;
                }
                return null;
            }
        }

        public override Forme Translation(PointForme p1, PointForme p2)
        {
            Groupe gTranslate = new Groupe(this.Nom);
            foreach (Forme s in _listeForme)
            {
                gTranslate.Add(s.Translation(p1, p2));
            }
            return gTranslate;
        }

        public override Forme Rotation(PointForme centre, double angle)
        {
            throw new NotImplementedException();
        }

        public override Forme Homothetie(PointForme p, double zoom)
        {
            Groupe gTranslate = new Groupe(this.Nom);
            foreach (Forme s in _listeForme)
            {
                gTranslate.Add(s.Homothetie(p, zoom));
            }
            return gTranslate;
        }

        public override void Draw(Graphics g)
        {
            if (_listeForme.Count > 0)
            {
                foreach (Forme s in _listeForme)
                {
                    s.Draw(g);
                }
            }
        }

        public override int NombreForme()
        {
            int nb = 0;
            foreach (Forme s in _listeForme)
            {
                nb += s.NombreForme();
            }
            return nb;
        }


        public override bool IsPresent(string name)
        {
            foreach (Forme s in _listeForme)
            {
                if (s.IsPresent(name))
                    return true;
            }
            return false;
        }

        public override bool IsGroup()
        {
            return true;
        }

        public override void save()
        {
            SingletonConnexion connexion = null;
            connexion = SingletonConnexion.getInstance();
            connexion.DAO_GROUPE.save(this);
        }
    }
}
