﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace ProjetDotNet.metier
{
    /*
     * Représente un groupe de forme, elle peut etre composé d'un groupe
     */
    public class ListeForme
    {
        private List<Forme> _listeForme;

        public List<Forme> TousLesFormes
        {
            get
            {
                return _listeForme;
            }
            set
            {
                _listeForme = value;
            }
        }

        public ListeForme(List<Forme> listeForme)
        {
            _listeForme = new List<Forme>();
            foreach (Forme s in listeForme)
            {
                _listeForme.Add(s);
            }

        }

        public ListeForme()
        {
            _listeForme = new List<Forme>();
        }

        public void Add(Forme forme)
        {
            _listeForme.Add(forme);
        }

        public void Add(List<Forme> f)
        {
            foreach (Forme s in f)
                _listeForme.Add(s);
        }

        public Forme Find(Forme forme)
        {
            return _listeForme.Find(f => f == forme);
        }

        public Forme GetFormeByName(string nom)
        {
            foreach (Forme s in _listeForme)
            {
                Forme temp = s.GetFormeByName(nom);
                if (temp != null)
                    return temp;
            }
            return null;
        }

        public Forme Translation(PointForme p1, PointForme p2)
        {
            throw new NotImplementedException();
        }

        public Forme Rotation(PointForme centre, double angle)
        {
            throw new NotImplementedException();
        }

        public Forme Homothetie(double zoom)
        {
            throw new NotImplementedException();
        }

        public void Draw(Graphics g)
        {
            if (_listeForme.Count > 0)
            {
                foreach (Forme s in _listeForme)
                {
                    s.Draw(g);
                }
            }
        }

        public int NombreForme()
        {
            int nb = 0;
            foreach (Forme s in _listeForme)
            {
                nb += s.NombreForme();
            }
            return nb;
        }
        
        private TreeNode GenerateTreeViewRec(Groupe g, TreeNode t)
        {
            int nb = 0;
            List<Forme> l = g.ListeForme;
            foreach (Forme s in l)
            {
                t.Nodes.Add(s.Nom);
                t.Nodes[nb].Tag = s;
                t.Nodes[nb].ForeColor = Color.Gray;
                if (s.IsGroup())
                    t.Nodes[nb] = GenerateTreeViewRec((Groupe)s, t.Nodes[nb]);

                nb += 1;
            }

            return t;
        }

        public void GenerateTreeView(TreeView t)
        {
            int nb = 0;
            foreach (Forme s in _listeForme)
            {
                t.Nodes.Add(s.Nom);
                t.Nodes[nb].Tag = s;
                if (s.IsGroup())
                {
                    
                    t.Nodes[nb].NodeFont = new Font(t.Font, FontStyle.Bold);
                    GenerateTreeViewRec((Groupe)s, t.Nodes[nb]);
                }
                t.Nodes[nb].ForeColor = Color.Black;

                nb += 1;
            }
        }


        public bool IsPresent(string name)
        {
            foreach (Forme s in _listeForme)
            {
                if (s.IsPresent(name))
                    return true;
            }
            return false;
        }

        public bool Remove(Forme forme)
        {
            return _listeForme.Remove(forme);
        }
    }
}
