﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ProjetDotNet.metier
{
    public class Point2
    {
            private double _x;
            private double _y;

            public Point2(double x, double y)
            {
                this._x = x;
                this._y = y;
            }

            public Point2()
            {
                this._x = 0.0;
                this._y = 0.0;
            }

            public float x { get; private set; }
            public float y { get; private set; }


            public static Point2 operator +(Point2 v1, Point2 v2)
            {
                return new Point2(v1.x + v2.x, v1.y + v2.y);
            }

            public static Point2 operator -(Point2 v1, Point2 v2)
            {
                return new Point2(v1.x - v2.x, v1.y - v2.y);
            }

            public static double operator *(Point2 v1, Point2 v2)
            {
                return v1.x * v2.x + v1.y * v2.y;
            }


            public Point2 Translation(Vector2 v)
            {
                return new Point2( this.x + v.x, this.y + v.y);
            }
            public Point2 Rotation(Point2 c, double angle)
            {
                double x0 = c.x;
                double y0 = c.y;
                double x = (this.x - x0) * Math.Cos(angle) - (_y - y0) * Math.Sin(angle) + x0;
                double y = (this.x - x0) * Math.Sin(angle) + (_y - y0) * Math.Cos(angle) + y0;

                return new Point2(x, y);
            }
            public Point2 Homothetie(Point2 c, double rapport)
            {
                double x0 = c.x;
                double y0 = c.y;
                double x = (this._x - x0) * rapport + x0;
                double y = (this._y - y0) * rapport + y0;

                return new Point2(x, y);
            }
    }
}
