﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using ProjetDotNet.web;

namespace ProjetDotNet.metier
{
    /*
     * Représente un polygone
     */
    public class Polygone:FormeSimple
    {
        public Polygone():base()
        {

        }

        public Polygone(String nom, Color couleur, List<PointForme> listePoint):base(nom, couleur,listePoint)
        {
            
        }

        public Polygone(String nom, Color couleur)
            : base(nom, couleur)
        {

        }

        public Polygone(Polygone p):base(p.Nom,p.Couleur)
        {
            this.ListePoint = new List<PointForme>(p.ListePoint);
        }

        public override string ToString()
        {
            String str = base.ToString();

            for (int i = 0; i < this.ListePoint.Count; i++)
            {
                str += " point " + (i+1) + " = " + this.ListePoint.ElementAt(i).ToString();
            }
                return str;
        }

        public override Forme Translation(PointForme p1, PointForme p2)
        {
            Polygone e = new Polygone(this.Nom, this.Couleur);
            e = (Polygone)this.TranslationPoint(e, p1, p2);
            return e;
        }

        public override Forme Rotation(PointForme centre, double angle)
        {
            Polygone e = new Polygone(this.Nom, this.Couleur);
            e = (Polygone)this.RotationPoint(e, centre, angle);
            return e;
        }

        public override Forme Homothetie(PointForme p, double zoom)
        {
            Polygone e = new Polygone(this.Nom, this.Couleur);
            e = (Polygone)this.HomothetiePoint(e, p, zoom);
            return e;
        }

        public override void Draw(Graphics g)
        {
            Pen p = new Pen(this.Couleur, 2);
            if (this.ListePoint.Count > 1)
            {
                for (int i = 0; i < this.ListePoint.Count-1; i++)
                {
                    Point point_n1 = new Point((int)this.ListePoint[i].X, (int)this.ListePoint[i].Y);
                    Point point_n2 = new Point((int)this.ListePoint[i+1].X, (int)this.ListePoint[i+1].Y);
                    g.DrawLine(p, point_n1, point_n2);
                }
                Point point_b = new Point((int)this.ListePoint[0].X, (int)this.ListePoint[0].Y);
                Point point_e = new Point((int)this.ListePoint[this.ListePoint.Count - 1].X, (int)this.ListePoint[this.ListePoint.Count - 1].Y);
                g.DrawLine(p, point_b, point_e);
            }
        }

        public override void save()
        {
            SingletonConnexion connexion = null;
            connexion = SingletonConnexion.getInstance();
            connexion.DAO_POLYGONE.save(this);
        }
    }
}
