﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using ProjetDotNet.web;

namespace ProjetDotNet.metier
{
    /*
     * Représente un segment
     */
    public class Segment : FormeSimple
    {
        public Segment() : base()
        {

        }

        public Segment(String nom, Color couleur, PointForme origine, PointForme extremite) : base(nom,couleur)
        {
            ListePoint.Add(origine);
            ListePoint.Add(extremite);
        }

        public Segment(String nom, Color couleur)
            : base(nom, couleur)
        {
        }


        public Segment(Segment seg):base(seg.Nom,seg.Couleur,seg.ListePoint)
        {

        }


        public Segment(String nom, Color couleur, List<PointForme>liste):base(nom,couleur,liste)
        {
            
        }


        public override Forme Translation(PointForme p1, PointForme p2)
        {
            Segment e = new Segment(this.Nom, this.Couleur);
            e = (Segment)this.TranslationPoint(e, p1, p2);
            return e;
        }

        public override Forme Rotation(PointForme centre, double angle)
        {
            Segment e = new Segment(this.Nom, this.Couleur);
            e = (Segment)this.RotationPoint(e, centre, angle);
            return e;
        }

        public override Forme Homothetie(PointForme p, double zoom)
        {
            Segment e = new Segment(this.Nom, this.Couleur);
            e = (Segment)this.HomothetiePoint(e, p, zoom);
            return e;
        }



        public override String ToString()
        {
            return base.ToString() + " origine = " + ListePoint[0] + " extremité = " + ListePoint[1];
        }

        public override void Draw(Graphics g)
        {
            Pen p = new Pen(this.Couleur, 2);
            Point origineDessin = new Point((int)this.ListePoint[0].X, (int)this.ListePoint[0].Y);
            Point extremiteDessin = new Point((int)this.ListePoint[1].X, (int)this.ListePoint[1].Y);
            g.DrawLine(p, origineDessin, extremiteDessin);
        }

        public override void save()
        {
            SingletonConnexion connexion = null;
            connexion = SingletonConnexion.getInstance();
            connexion.DAO_SEGMENT.save(this);
        }
    }
}
