﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using ProjetDotNet.web;

namespace ProjetDotNet.metier
{
    /*
     * Représente un triangle
     */
    public class Triangle : FormeSimple
    {
        public Triangle(): base()
        {

        }
        
        public Triangle(String nom, Color couleur, PointForme p1, PointForme p2, PointForme p3) : base(nom,couleur)
        {
            this.ListePoint.Add(p1);
            this.ListePoint.Add(p2);
            this.ListePoint.Add(p3);
        }

        public Triangle(String nom, Color couleur, List<PointForme> liste) : base(nom, couleur, liste)
        {

        }

        public Triangle(String nom, Color couleur)
            : base(nom, couleur)
        {

        }

        public Triangle(Triangle t): base(t.Nom,t.Couleur, t.ListePoint)
        {
             
        }

        public override String ToString()
        {
            return base.ToString() + " point 1 = " + ListePoint[0] + " point 2 = " + ListePoint[1] + " point 3 = " + ListePoint[2];
        }

        public override Forme Translation(PointForme p1, PointForme p2)
        {
            Triangle e = new Triangle(this.Nom, this.Couleur);
            e = (Triangle)this.TranslationPoint(e, p1, p2);
            return e;
        }

        public override Forme Rotation(PointForme centre, double angle)
        {
            Triangle e = new Triangle(this.Nom, this.Couleur);
            e = (Triangle)this.RotationPoint(e, centre, angle);
            return e;
        }

        public override Forme Homothetie(PointForme p, double zoom)
        {
            Triangle e = new Triangle(this.Nom, this.Couleur);
            e = (Triangle)this.HomothetiePoint(e, p, zoom);
            return e;
        }



        public override void Draw(Graphics g)
        {
            Pen p = new Pen(this.Couleur, 2);
            Point point_n1 = new Point((int)this.ListePoint[0].X, (int)this.ListePoint[0].Y);
            Point point_n2 = new Point((int)this.ListePoint[1].X, (int)this.ListePoint[1].Y);
            g.DrawLine(p, point_n1, point_n2);
            if (this.ListePoint.Count > 2)
            {
                Point point_n3 = new Point((int)this.ListePoint[2].X, (int)this.ListePoint[2].Y);
                g.DrawLine(p, point_n2, point_n3);
                g.DrawLine(p, point_n3, point_n1);
            }
        }

        public override void save()
        {
            SingletonConnexion connexion = null;
            connexion = SingletonConnexion.getInstance();
            connexion.DAO_TRIANGLE.save(this);
        }
    }
}
