﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ProjetDotNet.metier
{
    public class Vector2
    {
            private double _x;
            private double _y;

            public Vector2(double x, double y)
            {
                this._x = x;
                this._y = y;
            }

            public Vector2()
            {
                this._x = 0.0;
                this._y = 0.0;
            }

            public float x { get; private set; }
            public float y { get; private set; }


            public static Vector2 operator +(Vector2 v1, Vector2 v2)
            {
                return new Vector2(v1.x + v2.x, v1.y + v2.y);
            }

            public static Vector2 operator -(Vector2 v1, Vector2 v2)
            {
                return new Vector2(v1.x - v2.x, v1.y - v2.y);
            }

            public static Vector2 operator *(Vector2 v1, float m)
            {
                return new Vector2(v1.x * m, v1.y * m);
            }

            public static double operator *(Vector2 v1, Vector2 v2)
            {
                return v1.x * v2.x + v1.y * v2.y;
            }

    
    }
}
