﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ProjetDotNet.mouseEvent
{

    /*
     * Classe permettant de gérer les événements lier au clique de la souris sur la zone de dessin de la fenetre principale
     */
    class MouseClickManager
    {
        private List<MouseEventHandler> liste_handler;

        private Panel panel;

        public List<MouseEventHandler> Liste_handler
        {
            get
            {
                return liste_handler;
            }
            set
            {
                liste_handler = value;
            }
        }

        public MouseClickManager(Panel panel)
        {
            this.panel = panel;
            liste_handler = new List<MouseEventHandler>();
        }

        /* 
         * Ajout d'une action
         */
        public void addEvent(MouseEventHandler handler)
        {
            this.panel.MouseClick += handler;
            Liste_handler.Add(handler);
        }

        /*
         * Suppression d'une action
         */
        public void deleteEvent(MouseEventHandler handler)
        {
            this.panel.MouseClick -= handler;
            Liste_handler.Remove(handler);
        }

        /*
         * Suppression de toutes les actions
         */
        public void deleteAllEvent()
        {
            List<MouseEventHandler> handlers = new List<MouseEventHandler>(Liste_handler);

            foreach (MouseEventHandler handler in handlers)
            {
                deleteEvent(handler);
            }
        }

    }
}
